/*******************************************************************************
*   Author       -  Kiraly Tibor                                               *
*                   www.tkiraaly.hu                                            *
*   Date         -  2012.06.22.                                                *
*   Chip         -  Atmel ATtiny2313                                           *
*   Compiler     -  avr-gcc (WinAVR 20080610) 4.3.0                            *
*                                                                              *
*   Definitions for ATtiny2313                                                 *
*                                                                              *
*******************************************************************************/
#include <avr/sfr_defs.h>




// 0x00 Reserved

#define DIDR    _SFR_IO8( 0x01)        // Digital Input Disable Register
#define AIN1D   1
#define AIN0D   0

#define UBRRH   _SFR_IO8( 0x02)        // USART Baud Rate Register High [11:8]

#define UCSRC   _SFR_IO8( 0x03)        // USART Control and Status Register C
#define UMSEL   6                      // USART Mode Select
#define UPM1    5                      // Parity Mode 1 
#define UPM0    4                      // Parity Mode 0
#define USBS    3                      // Stop Bit Select
#define UCSZ1   2                      // Character Size 2
#define UCSZ0   1                      // Character Size 1
#define UCPOL   0                      // Character Size 0

// 0x04 Reserved
// 0x05 Reserved
// 0x06 Reserved
// 0x07 Reserved

#define ACSR    _SFR_IO8( 0x08)        // Analog Comparator Control and Status Register
#define ACD     7
#define ACBG    6
#define ACO     5
#define ACI     4
#define ACIE    3
#define ACIC    2
#define ACIS1   1
#define ACIS0   0

#define UBRRL   _SFR_IO8( 0x09)        // USART Baud Rate Register Low [7:0]

#define UCSRB   _SFR_IO8( 0x0A)        // USART Control and Status Register B
#define RXCIE   7                      // RX Complete Interrupt Enable
#define TXCIE   6                      // TX Complete Interrupt Enable
#define UDRIE   5                      // USART Data Register Empty Interrupt Enable
#define RXEN    4                      // Receive Enable
#define TXEN    3                      // Transmitter Enable
#define UCSZ2   2                      // Character Size
#define RXB8    1                      // Receive Data Bit 8
#define TXB8    0                      // Transmit Data Bit 8

#define UCSRA   _SFR_IO8(0x0B)         // USART Control and Status Register A
#define RXC     7                      // USART Receive Complete
#define TXC     6                      // USART Transmit Complete
#define UDRE    5                      // USART Data Register Empty
#define FE      4                      // Frame Error 
#define DOR     3                      // Data Overrun
#define UPE     2                      // USART Parity Error
#define U2X     1                      // Double the USART Transmission Speed
#define MPCM    0                      // Multiprocessor Communication Mode

#define UDR     _SFR_IO8( 0x0C)        // USART I/O Data Register [7:0]

#define USICR   _SFR_IO8( 0x0D)        // USI Control Register
#define USISIE  7
#define USIOIE  6
#define USIWM1  5
#define USIWM0  4
#define USICS1  3
#define USICS0  2
#define USICLK  1
#define USITC   0

#define USISR   _SFR_IO8(0x0E)         // USI Status Register
#define USISIF  7
#define USIOIF  6
#define USIPF   5
#define USIDC   4
#define USICNT3 3
#define USICNT2 2
#define USICNT1 1
#define USICNT0 0

#define USIDR   _SFR_IO8( 0x0F)        // USI Data Register [7:0]

#define PIND    _SFR_IO8( 0x10)        // Input Pins, Port D [6:0]

#define DDRD    _SFR_IO8( 0x11)        // Data Direction Register, Port D [6:0]

#define PORTD   _SFR_IO8( 0x12)        // Data Register, Port D [6:0]

#define GPIOR0  _SFR_IO8( 0x13)        // General Purpose I/O Register Zero [7:0]

#define GPIOR1  _SFR_IO8( 0x14)        // General Purpose I/O Register One [7:0]

#define GPIOR2  _SFR_IO8( 0x15)        // General Purpose I/O Register Two [7:0]

#define PINB    _SFR_IO8( 0x16)        // Input Pins, Port B [7:0]

#define DDRB    _SFR_IO8( 0x17)        // Data Direction Register, Port B [7:0]

#define PORTB   _SFR_IO8( 0x18)        // Data Register, Port B [7:0]

#define PINA    _SFR_IO8( 0x19)        // Port A Input Pins Address [2:0]

#define DDRA    _SFR_IO8( 0x1A)        // Port A Data Direction Register [2:0]

#define PORTA   _SFR_IO8( 0x1B)        // Port A Data Register [2:0]

#define EECR    _SFR_IO8( 0x1C)        // EEPROM Control Register
#define EEPM1   5                      // EEPROM Programming Mode Bit
#define EEPM0   4                      // EEPROM Programming Mode Bit
#define EERIE   3                      // EEPROM Ready Interrupt Enabla Bit
#define EEMPE   2                      // EEPROM Master Program Enable Bit
#define EEPE    1                      // EEPROM Program Enable Bit
#define EERE    0                      // EEPROM Read Enable Bit

#define EEDR    _SFR_IO8( 0x1D)        // EEPROM Data Register

#define EEAR    _SFR_IO8( 0x1E)        // EEPROM Address Register

// 0x1F Reserved

#define PCMSK   _SFR_IO8( 0x20)        // Pin Change Mask Register [7:0]
#define PCINT7  7
#define PCINT6  6
#define PCINT5  5
#define PCINT4  4
#define PCINT3  3
#define PCINT2  2
#define PCINT1  1
#define PCINT0  0

#define WDTCSR  _SFR_IO8( 0x21)        // Watchdog Timer Control Register
#define WDIF    7
#define WDIE    6
#define WDP3    5
#define WDCE    4
#define WDE     3
#define WDP2    2
#define WDP1    1
#define WDP0    0

#define TCCR1C  _SFR_IO8( 0x22)/       // Timer/Counter1 Control Register C
#define FOC1A   7
#define FOC1B   6

#define GTCCR   _SFR_IO8( 0x23)        // General Timer/Counter Control Register
#define PSR10   0

#define ICR1    _SFR_IO16( 0x24)       // T/C 1 Input Capture Register [15:0]
#define ICR1L   _SFR_IO8( 0x24)
#define ICR1H   _SFR_IO8( 0x25)

#define CLKPR   _SFR_IO8( 0x26)        // Clock Prescale Register
#define CLKPCE  7
#define CLKPS3  3
#define CLKPS2  2
#define CLKPS1  1
#define CLKPS0  0

// 0x27 Reserved

#define OCR1B   _SFR_IO16( 0x28)       // Timer/Counter 1 Compare Register B [15:0]
#define OCR1BL  _SFR_IO8( 0x28)
#define OCR1BH  _SFR_IO8( 0x29)

#define OCR1A   _SFR_IO16( 0x2A)       // Timer/Counter 1 Compare Register A [15:0]
#define OCR1AL  _SFR_IO8( 0x2A)
#define OCR1AH  _SFR_IO8( 0x2B)

#define TCNT1   _SFR_IO16( 0x2C)       // Timer/Counter 1 Counter Register[15:0]
#define TCNT1L  _SFR_IO8( 0x2C)
#define TCNT1H  _SFR_IO8( 0x2D)

#define TCCR1B  _SFR_IO8( 0x2E)        // Timer/Counter 1 Control and Status Register
#define ICNC1   7
#define ICES1   6
#define WGM13   4
#define WGM12   3
#define CS12    2
#define CS11    1
#define CS10    0

#define TCCR1A  _SFR_IO8( 0x2F)        // Timer/Counter 1 Control Register
#define COM1A1  7
#define COM1A0  6
#define COM1B1  5
#define COM1B0  4
#define WGM11   1
#define WGM10   0

#define TCCR0A  _SFR_IO8( 0x30)        // Timer/Counter 0 Control Register A
#define COM0A1  7
#define COM0A0  6
#define COM0B1  5
#define COM0B0  4
#define WGM01   1
#define WGM00   0

#define OSCCAL  _SFR_IO8( 0x31)        // Oscillator Calibration Register [6:0]
#define CAL6    6
#define CAL5    5
#define CAL4    4
#define CAL3    3
#define CAL2    2
#define CAL1    1
#define CAL0    0

#define TCNT0   _SFR_IO8( 0x32)        // Timer/Counter 0 [7:0]

#define TCCR0B  _SFR_IO8( 0x33)        // Timer/Counter 0 Control Register B
#define FOC0A   7
#define FOC0B   6
#define WGM02   3
#define CS02    2
#define CS01    1
#define CS00    0

#define MCUSR   _SFR_IO8( 0x34)        // MCU Status Register
#define WDRF    3
#define BORF    2
#define EXTRF   1
#define PORF    0

#define MCUCR   _SFR_IO8( 0x35)        // MCU general Control Register
#define PUD     7
#define SM1     6
#define SE      5
#define SM0     4
#define ISC11   3
#define ISC10   2
#define ISC01   1
#define ISC00   0

#define OCR0A   _SFR_IO8( 0x36)        // Timer/Counter 0 Compare Register A [7:0]  (PWM szamlalo felso erteke)

#define SPMCSR  _SFR_IO8( 0x37)        // Store Program Memory Control and Status Register
#define CTPB    4
#define RFLB    3
#define PGWRT   2
#define PGERS   1
#define SPMEN   0                      // The name is used in ATtiny2313.xml file.
#define SELFPRGEN 0                    // The name is used in datasheet.
#define SELFPRGE  0                    // The name is left for compatibility.

#define TIFR    _SFR_IO8( 0x38)        // Timer/Counter Interrupt Flag Register
#define TOV1    7
#define OCF1A   6
#define OCF1B   5
#define ICF1    3
#define OCF0B   2
#define TOV0    1
#define OCF0A   0

#define TIMSK   _SFR_IO8( 0x39)        // Timer/Counter Interrupt Mask Register
#define TOIE1   7
#define OCIE1A  6
#define OCIE1B  5
#define ICIE1   3
#define OCIE0B  2
#define TOIE0   1
#define OCIE0A  0

#define EIFR    _SFR_IO8( 0x3A)        // External Interrupt Flag Register (was GIFR)
#define INTF1   7
#define INTF0   6
#define PCIF    5


#define GIMSK   _SFR_IO8( 0x3B)        // General Interrupt MaSK Register
#define INT1    7
#define INT0    6
#define PCIE    5

#define OCR0B   _SFR_IO8( 0x3C)        // Timer/Counter 0 Compare Register B [7:0]

#define SP      _SFR_IO16( 0x3D)       // Stack Pointer
#define SPL     _SFR_IO8( 0x3D)

// 0x3E Reserved

#define SREG    _SFR_IO8( 0x3F)        // Status Register
#define SREG_I  7                      // Global Interrupt Enable
#define SREG_T  6                      // Bit Copy Storage
#define SREG_H  5                      // Half Carry Flag
#define SREG_S  4                      // Sign Bit
#define SREG_V  3                      // Two's Complements Overflows Flag
#define SREG_N  2                      // Negativ Flag
#define SREG_Z  1                      // Zero Flag
#define SREG_C  0                      // Carry Flag




// Interrupt vectors:
#define RESET_vect	       _VECTOR(0)  // RESET
#define INT0_vect	         _VECTOR(1)  // External Interrupt Request 0
#define INT1_vect	         _VECTOR(2)  // External Interrupt Request 1
#define TIMER1_CAPT_vect   _VECTOR(3)  // Timer/Counter1 Capture Event
#define TIMER1_COMPA_vect  _VECTOR(4)  // Timer/Counter1 Compare Match A
#define TIMER1_OVF_vect	   _VECTOR(5)  // Timer/Counter1 Overflow
#define TIMER0_OVF_vect	   _VECTOR(6)  // Timer/Counter0 Overflow
#define USART_RX_vect	     _VECTOR(7)  // USART, Rx Complete - vetel kesz
#define USART_UDRE_vect	   _VECTOR(8)  // USART Data Register Empty - buffer ures
#define USART_TX_vect	     _VECTOR(9)  // USART, Tx Complete - adas kesz
#define ANA_COMP_vect	     _VECTOR(10) // Analog Comparator
#define PCINT_vect	       _VECTOR(11) // PIN Change Interrupt
#define TIMER1_COMPB_vect  _VECTOR(12) // Timer/Counter1 Compare Match B 
#define TIMER0_COMPA_vect  _VECTOR(13) // Timer/Counter0 Compare Match A
#define TIMER0_COMPB_vect  _VECTOR(14) // Timer/Counter0 Compare Match B
#define USI_START_vect	   _VECTOR(15) // USI Start Condition
#define USI_OVERFLOW_vect  _VECTOR(16) // USI Overflow
#define EEPROM_READY_vect  _VECTOR(17) // EEPROM Ready
#define WDT_OVERFLOW_vect  _VECTOR(18) // Watchdog Timer Overflow




/* Constants: */
#define _VECTORS_SIZE   38             // 38 = (18*2)+2: Number of vectors times two, plus the reset vector
#define RAMEND          0xDF
#define XRAMEND         0xDF
#define E2END           0x7F
#define FLASHEND        0x07FF
#define SPM_PAGESIZE    32




/* Pointer definition */
#define    XL           r26
#define    XH           r27
#define    YL           r28
#define    YH           r29
#define    ZL           r30
#define    ZH           r31




#define UC                   unsigned char
#define MHz                  000000
#define kHz                  000



// lasd sfr_defs.h 
//#define BS(bit)              |= ( 1 << ( bit))                // egy byte adott bitjenek 1-re allitas
//#define BC(bit)              &= ~( 1 << ( bit))               // egy byte adott bitjenek 0-ra allitas

#define BS(sfr,bit)          sfr|= ( 1 << ( bit))               // BIT-SET - egy regiszter adott bitjenek 1-re allitas
#define BC(sfr,bit)          sfr&= ~( 1 << ( bit))              // BIT-CLEAR - egy regiszter adott bitjenek 0-ra allitas
#define BTS(sfr,bit)         bit_is_set( sfr, bit)              // BIT-TEST-SET - egy regiszter egy bitjenek vizsgalata 1-re
#define BTC(sfr,bit)         bit_is_clear( sfr, bit)            // BIT-TEST-CLEAR - egy regiszter egy bitjenek vizsgalata 0-ra
#define IT_ENABLE            __asm__ __volatile__ ("sei" ::)    // megszakitas engedelyezese
#define IT_DISABLE           __asm__ __volatile__ ("cli" ::)    // megszakitas tiltasa
#define NOP                  __asm__ __volatile__ ("nop" ::)    // egy ures utasitas beszurasa




// USART inicializalasahoz, kezelesehez

// UCSRA beallitasai
#define DOUBLE_SPEED         0B00000010
#define MULTIPROC            0B00000001

// UCSRA lekerdezese
#define RX_ERROR             UCSRA & 0B00011100  // hiba lekerdezese, 0 - nincs hiba
#define RX_COMPLETE          BTS( UCSRA, RXC)    // vetel befejezodott
#define TX_COMPLETE          BTS( UCSRA, TSC)    // adas befejezodott
#define UDR_EMPTY            BTS( UCSRA, UDRE)   // adat buffer ures
#define UDR_NOT_EMPTY        BTC( UCSRA, UDRE)   // adat buffer nem ures

// UCSRB beallitasai
#define IT_RX_DISABLE        0                   // vetel kesz megszakitas tiltasa/engedelyezese
#define IT_RX_ENABLE         0B10000000
#define IT_TX_DISABLE        0                   // adas kesz megszakitas tiltasa/engedelyezese
#define IT_TX_ENABLE         0B01000000
#define IT_UDR_EMPTY_DISABLE 0                   // adat buffer ures megszakitas tiltasa/engedelyezese
#define IT_UDR_EMPTY_ENABLE  0B00100000
#define RX_DISABLE           0                   // vetel tiltasa/engedelyezese
#define RX_ENABLE            0B00010000
#define TX_DISABLE           0                   // adas tiltasa/engedelyezese
#define TX_ENABLE            0B00001000

// UCSRC beallitasai
#define ASYNCRON             0                   // asszinkron mukodes
#define SYNCRON              0B01000000          // szinkron mukodes
#define PARITY_NO            0                   // nincs paritas bit
#define PARITY_EVEN          0B00100000          // paros paritas
#define PARITY_ODD           0B00110000          // paratlan paritas
#define STOPBIT_1            0                   // 1 stopbit
#define STOPBIT_2            0B00001000          // 2 stopbit
#define BIT_5                0                   // 5 bit-es karakterhossz
#define BIT_6                0B00000010          // 6 bit-es karakterhossz
#define BIT_7                0B00000100          // 7 bit-es karakterhossz
#define BIT_8                0B00000110          // 8 bit-es karakterhossz




// TIMERx inicializalasahoz, kezelesehez

#define OC0A_ENABLE          BS(DDRB,2)
#define OC0B_ENABLE          BS(DDRD,5)
#define OC1A_ENABLE          BS(DDRB,3)
#define OC1B_ENABLE          BS(DDRB,4)

// TCCR0A beallitasai
#define T_NORMAL             0                   // nomal szamlalo
#define T_CTC                0B00000001          // OCRxA erteknel 0-ra ugrik...
#define T_PWM_PC             0B00000010          // fazis korrekt PWM ?
#define T_PWM_FAST_MAX       0B00000001          // 0-255 kozott szamol, kimenet OCxA, OCRxA-hez komparal
#define T_PWM_FAST_TOP       0B00000011          // 0-OCRxA kozott szamol, kimenet OCxB, OCRxB-hez komparal 

#define T_NC                 0                   // OCxA levalasztva (es OCxB is)
#define T_CTC_TOGGLE_A       0B01000000          // OCRxA erteknel OCxA allapotot valt (50%!)
#define T_CTC_CLEAR_A        0B10000000          // OCRxA erteknel OCxA 0-ra ? 
#define T_CTC_SET_A          0B11000000          // OCRxA erteknel OCxA 1-re ?
#define T_PWM_FAST_CLEAR_A   0B10000000          // OCRxA erteknel OCxA 0-ra, 255-ig
#define T_PWM_FAST_SET_A     0B11000000          // OCRxA erteknel OCxA 1-re, 255-ig
#define T_PWM_PC_CLEAR_A     0B10000000          // OCRxA erteknel OCxA 0-ra, majd visszafele OCRxA erteknel 1-re ?
#define T_PWM_PC_SET_A       0B11000000          // OCRxA erteknel OCxA 1-re, majd visszafele OCRxA erteknel 0-ra ?
#define T_PWM_FAST_CLEAR_B   0B00100000          // OCRxB erteknel OCxB 0-ra, 255-ig
#define T_PWM_FAST_SET_B     0B00110000          // OCRxB erteknel OCxB 1-re, 255-ig


// TCCR0B, TCCR1B beallitasai
#define T_STOP               0                   // nincs orajel, STOP
#define T_CS1                0B00000001          // rendszer orajel/ 1
#define T_CS8                0B00000010          // rendszer orajel/ 8
#define T_CS64               0B00000011          // rendszer orajel/ 64
#define T_CS256              0B00000100          // rendszer orajel/ 256
#define T_CS1024             0B00000101          // rendszer orajel/ 1024
#define T_CEXTF              0B00000110          // kulso orajel (T0) lefuto elere
#define T_CEXTR              0B00000111          // kulso orajel (T0) felfuto elere
#define T_PWM_TOP            0B00001000          // PWM uzemmodba OCRxA ertekig megy a timer


// TIMSK beallitasai
#define IT_T1OVF_DISABLE     0                   // Timer/Counter1 Overflow megszakitas tiltasa/engedelyezese
#define IT_T1OVF_ENABLE      0B10000000
#define IT_T1CPA_DISABLE     0                   // Timer/Counter1 Compare Match A megszakitas tiltasa/engedelyezese
#define IT_T1CPA_ENABLE      0B01000000
#define IT_T1CPB_DISABLE     0                   // Timer/Counter1 Compare Match B megszakitas tiltasa/engedelyezese
#define IT_T1CPB_ENABLE      0B00100000
#define IT_T1INC_DISABLE     0                   // Timer/Counter1 Input Capture megszakitas tiltasa/engedelyezese
#define IT_T1INC_ENABLE      0B00001000
#define IT_T0CPA_DISABLE     0                   // Timer/Counter0 Compare Match A megszakitas tiltasa/engedelyezese
#define IT_T0CPA_ENABLE      0B00000001
#define IT_T0OVF_DISABLE     0                   // Timer/Counter0 Overflow megszakitas tiltasa/engedelyezese
#define IT_T0OVF_ENABLE      0B00000010
#define IT_T0CPB_DISABLE     0                   // Timer/Counter0 Compare Match B megszakitas tiltasa/engedelyezese
#define IT_T0CPB_ENABLE      0B00000100
